﻿/*
DATA
	[previewList]
		path				(level path)
		image				(full-size bitmapData)
		width				(width of map in pixels)
		height			(height pf map in pixels)
		(collision)		(2D array)

FUNCTIONS
	getPreviewData( levelPath )
	
EVENTS  (external functions)
	onAllPreviewsLoaded()
	showPreview( data )
*/
// // make a list of all levels
loadPreviews = function()
{
	previewList = [];
	
	
	
	// create preview images of every level
	// // snapshot function		(loads a level, draws its map, then stores a bitmap of it)
	previewsLoaded = 0;
	load_mc = this.createEmptyMovieClip("load_mc", 0);
	#include "functions/map.as"
	#include "functions/readXml.as"
	getLevelImage = function( path, output_obj )
	{
		var newDepth = nextDepth(load_mc);
		var newName = "map_"+newDepth;
		var thisMap = makeMap( newName, load_mc, newDepth );
		// return the loaded bitmap
		//return output;
		thisMap.onLoad = function()
		{
			// take a snapshot
			var imageWidth = this.width *16;
			var imageHeight = this.height *16;
			var output_pic = new flash.display.BitmapData( imageWidth, imageHeight, false, 0 );
			output_pic.draw( this );
			// output the bitmap
			output_obj.image = output_pic;
			output_obj.width = this.width;
			output_obj.height = this.height;
	
			output_obj.collision = this.collision_array;
			showPreview( output_obj );
			// announce that all previews are loaded
			previewsLoaded++;
			if(previewsLoaded == previewList.length)
				onAllPreviewsLoaded();
			// remove this map
			this.removeMovieClip();
		}// onLoad()
		// load the map specified
		XML.prototype.ignoreWhite = true;
		var level_xml = new XML();
		level_xml.map = thisMap;
		level_xml.onLoad = function( success )
		{
			if(success)
			{
				// convert data
				var levelData = {};
				readXml( level_xml.firstChild, levelData );
				// pass map data to the map system
				level_xml.map.drawObj( levelData.level.map );
			}
		}
		level_xml.load( path );
	}// getLevelImage()
	
	
	
	// add a level to the preview list
	addlevel = function( path )
	{
		newLevel = {
			path:path,
			image:null,
			width:null,
			height:null,
			collision:null
		}
		previewList.push( newLevel );
		getLevelImage( path, newLevel );
	}// addlevel
	getPreviewData = function( levelPath )
	{
		for(var i in previewList)
		{// for:  all loaded levels
			if(previewList[i].path == levelPath)
			{// if:  level data found
				var output = previewList[i];
				break;
			}// if:  level data found
		}// for:  all loaded levels
		return output;
	}// getPreviewData()
	
	var appPath = mdm.Application.path;
	getLevels = function( path )
	{
		// add files in this folder
		var fileList = mdm.FileSystem.getFileList( (appPath+path), "*.lvl");
		for(var fi=0; fi<fileList.length; fi++)
			addlevel( path+fileList[fi] );
		// add files in sub-folders
		var folderList = mdm.FileSystem.getFolderList( appPath+path );
		for(var fo=0; fo<folderList.length; fo++)
			getLevels( path+folderList[fo]+"\\" );
	}// getLevels()
	
	
	if(previewList.length==0)
	{// if:  no previews loaded
		getLevels( "levels\\", previewList );
	}// if:  no previews loaded
	else
	{// if:  previews already loaded
		for(var nam in previewList)
			showPreview( previewList[nam] );
		onAllPreviewsLoaded();
	}// if:  previews already loaded
}// loadPreviews()